<?php

$new_config_file = '../include/config.php';
$old_config_file = 'old_site_config.php';

if (file_exists($old_config_file)) {
    $file_contents = file_get_contents($old_config_file);

    $extended_version = false;
    if (strpos($file_contents, '$config->pro_version') !== false) {
        $extended_version = true;
    }
}

if (is_writable($new_config_file)) {
    $upgrade_info = array();

    if (file_exists("upgrade_info.php")) {
        $upgrade_info_content = file_get_contents('upgrade_info.php');
        $upgrade_info_content = json_decode($upgrade_info_content, true);
        if (!empty($upgrade_info_content)) {
            $upgrade_info = $upgrade_info_content;
        }
    }

    $database = $upgrade_info['db'];

    $file_contents = file_get_contents($new_config_file);
    $file_contents = preg_replace("/'host' => '([^']+(?='))'/", "'host' => '" . $database['host'] . "'", $file_contents);
    $file_contents = preg_replace("/'database' => '([^']+(?='))'/", "'database' => '" . $database['database'] . "'", $file_contents);
    $file_contents = preg_replace("/'username' => '([^']+(?='))'/", "'username' => '" . $database['username'] . "'", $file_contents);
    $file_contents = preg_replace("/'password' => '([^']+(?='))'/", "'password' => '" . $database['password'] . "'", $file_contents);
    $file_contents = preg_replace("/'port' => '([^']+(?='))'/", "'port' => '" . $database['port'] . "'", $file_contents);

    if ($extended_version) {
        $newLine = "\n\$config->pro_version = 'pro';\n";
        $pattern = '/(\$db_error_mode\s*=\s*PDO::ERRMODE_SILENT\s*;)/';

        if (preg_match($pattern, $file_contents, $matches, PREG_OFFSET_CAPTURE)) {
            $position = $matches[0][1];
            $file_contents = substr_replace($file_contents, $newLine, $position, 0);
        }

    }

    file_put_contents($new_config_file, $file_contents);


    $page_content = [
        'title' => 'Allocating Images',
        'loading_text' => 'Allocating Images',
        'subtitle' => 'Please Wait',
        'redirect' => '../basic_process/'
    ];
} else {
    $page_content = [
        'title' => 'Error',
        'page_content' => 'Error : Unable to read/write files. Kindly check folder permssions & ownership.',
        'heading' => 'OOPS',
        'page_status' => 'error',
        'button_text' => 'Reload',
        'button_link' => 'index.php?process=build_config'
    ];
}
