<?php grupo_chat_sso_load_css(array("assets/css/grupo_chat_sso_styles.css")); ?>
<div id="page-content" class="page-wrapper clearfix">
    <div class="row">
        <div class="col-sm-3 col-lg-2">
            <?php
            $tab_view['active_tab'] = "grupo_chat_sso";
            echo view("settings/tabs", $tab_view);
            ?>
        </div>

        <div class="col-sm-9 col-lg-10">
            <div class="card">

                <div class="card-header">
                    <h4>Grupo Chat Integration</h4>
                </div>

                <?php echo form_open(get_uri("grupo_chat_sso_settings/save"), array("id" => "grupo_chat_sso-settings-form", "class" => "general-form dashed-row", "role" => "form")); ?>

                <div class="card-body">
                    <div class="form-group">
                        <div class="row">
                            <label for="grupo_chat_url" class=" col-md-3">Grupo Chat URL</label>
                            <div class=" col-md-9">
                                <?php
                                echo form_input(array(
                                    "id" => "grupo_chat_url",
                                    "name" => "grupo_chat_url",
                                    "value" => get_grupo_chat_sso_setting("grupo_chat_url"),
                                    "class" => "form-control",
                                    "placeholder" => "Your Grupo Website Address"
                                ));
                                ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <div class="row">
                            <label for="grupo_chat_api_key" class=" col-md-3">Grupo Chat API Key</label>
                            <div class=" col-md-9">
                                <?php
                                echo form_input(array(
                                    "id" => "grupo_chat_api_key",
                                    "name" => "grupo_chat_api_key",
                                    "value" => get_grupo_chat_sso_setting("grupo_chat_api_key"),
                                    "class" => "form-control",
                                    "placeholder" => "Enter your Grupo API Key"
                                ));
                                ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <div class="row">
                            <label for="grupo_chat_status" class=" col-md-3">Add to Navigation Menu</label>
                            <div class=" col-md-9">
                                <?php
                                echo form_dropdown(array(
                                    "id" => "grupo_chat_status",
                                    "name" => "grupo_chat_status",
                                    "selected" => get_grupo_chat_sso_setting("grupo_chat_status"),
                                    "class" => "form-control",
                                    "options" => ['0' => '------------','yes' => 'Yes', 'no' => 'No']
                                ));
                                ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <div class="row">
                            <label for="grupo_chat_open_parent_window" class=" col-md-3">Open Chat in Parent Window</label>
                            <div class=" col-md-9">
                                <?php
                                echo form_dropdown(array(
                                    "id" => "grupo_chat_open_parent_window",
                                    "name" => "grupo_chat_open_parent_window",
                                    "selected" => get_grupo_chat_sso_setting("grupo_chat_open_parent_window"),
                                    "class" => "form-control",
                                    "options" => ['0' => '------------','yes' => 'Yes', 'no' => 'No']
                                ));
                                ?>
                            </div>
                        </div>
                    </div>


                </div>

                <div class="card-footer">
                    <button type="submit" class="btn btn-primary"><span data-feather="check-circle" class="icon-16"></span> <?php echo app_lang('save'); ?></button>
                </div>

            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    "use strict";

    $(document).ready(function () {
        $("#grupo_chat_sso-settings-form").appForm({
            isModal: false,
            onSuccess: function (result) {
                appAlert.success(result.message, {duration: 10000});
            }
        });

        var uploadUrl = "<?php echo get_uri("grupo_chat_sso_settings/upload_file"); ?>";
        var validationUrl = "<?php echo get_uri("grupo_chat_sso_settings/validate_grupo_chat_sso_file"); ?>";

        var dropzone = attachDropzoneWithForm("#grupo_chat_sso-settings-form", uploadUrl, validationUrl, {maxFiles: 1});
    });
</script>