<?php
namespace Grupo_chat_sso\Models;
use App\Models\Crud_model;
class Grupo_chat_sso_settings_model extends Crud_model {
    protected $table = null;
    function __construct() {
        $this->table = "grupo_chat_sso_settings";
        parent::__construct($this->table);
    }
    function get_setting($setting_name) {
        $result = $this->db_builder->getWhere(["setting_name" => $setting_name], 1);
        if (count($result->getResult()) == 1) {
            return $result->getRow()->setting_value;
        }
    }
    function validate_grupo_api($grupo_url, $grupo_api) {
        $result = false;
        if (!empty($grupo_url)) {
            
            $grupo_post_data = ["api_secret_key" => $grupo_api, "add" => "login_session", "user" => "api_request_test583602", ];
            $grupo_curl_response = grupo_curl_request($grupo_post_data, $grupo_url);
            
            if (!empty($grupo_curl_response) && is_object($grupo_curl_response)) {
                if (isset($grupo_curl_response->error_key) && $grupo_curl_response->error_key === "invalid_api_secret_key") {
                    $result = false;
                } else {
                    $result = true;
                }
            }
        }
        return $result;
    }
    function save_setting($setting_name, $setting_value, $type = "app") {
        $fields = ["setting_name" => $setting_name, "setting_value" => $setting_value, ];
        $exists = $this->get_setting($setting_name);
        if ($exists === null) {
            $fields["type"] = $type; //type can't be updated
            return $this->db_builder->insert($fields);
        } else {
            $this->db_builder->where("setting_name", $setting_name);
            $this->db_builder->update($fields);
        }
    }
    //find all settings
    function get_all_settings() {
        $settings_table = $this->db->prefixTable("grupo_chat_sso_settings");
        $sql = "SELECT $settings_table.setting_name,  $settings_table.setting_value
        FROM $settings_table
        WHERE $settings_table.deleted=0";
        return $this->db->query($sql);
    }
}
