<?php

namespace Grupo_chat_sso\Controllers;

use App\Controllers\Security_Controller;

class Grupo_chat_sso_settings extends Security_Controller
{
    protected $Grupo_chat_sso_settings_model;

    function __construct()
    {
        parent::__construct();
        $this->access_only_admin_or_settings_admin();
        $this->Grupo_chat_sso_settings_model = new \Grupo_chat_sso\Models\Grupo_chat_sso_settings_model();
    }

    function index()
    {
        return $this->template->rander("Grupo_chat_sso\Views\settings\index");
    }

    function save()
    {
        $grupo_url = trim($this->request->getPost("grupo_chat_url"));
        $group_api = trim($this->request->getPost("grupo_chat_api_key"));
        $grupo_status = $this->request->getPost("grupo_chat_status");
        $open_parent_window = $this->request->getPost(
            "grupo_chat_open_parent_window"
        );

        if ($this->Grupo_chat_sso_settings_model->validate_grupo_api($grupo_url, $group_api)) {
            $this->Grupo_chat_sso_settings_model->save_setting(
                "grupo_chat_url",
                $grupo_url
            );
            $this->Grupo_chat_sso_settings_model->save_setting(
                "grupo_chat_api_key",
                $group_api
            );
            $this->Grupo_chat_sso_settings_model->save_setting(
                "grupo_chat_status",
                $grupo_status
            );
            $this->Grupo_chat_sso_settings_model->save_setting(
                "grupo_chat_open_parent_window",
                $open_parent_window
            );

            echo json_encode([
                "success" => true,
                "message" => app_lang("settings_updated"),
            ]);
        } else {
            echo json_encode([
                "success" => false,
                "message" => "Invalid API Key or Grupo URL",
            ]);
        }
    }
}
